Attribute VB_Name = "Functions"
Private Declare Function WritePrivateProfileString Lib "kernel32" _
    Alias "WritePrivateProfileStringA" _
    (ByVal lpApplicationName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpString As Any, _
    ByVal lpFileName As String) As Long

Private Declare Function GetPrivateProfileString Lib "kernel32" _
    Alias "GetPrivateProfileStringA" _
    (ByVal lpApplicationName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpDefault As String, _
    ByVal lpReturnedString As String, _
    ByVal nSize As Long, _
    ByVal lpFileName As String) As Long

Public iniFile As String

Public Function ReadINIKey(Section As String, keyName As String, FileName As String) As String
    Dim retVal As String

    retVal = String(255, Chr(0))
    ReadINIKey = Left(retVal, GetPrivateProfileString(Section, keyName, "", retVal, Len(retVal), FileName))
End Function

Public Function WriteINIKey(Section As String, keyName As String, KeyValue As String, FileName As String)
    WritePrivateProfileString Section, keyName, KeyValue, FileName
End Function

Public Function WindowTitle(ByVal hwnd As Long) As String
    Dim stBuff As String

    stBuff = String(250, Chr$(0))
    GetWindowText hwnd, stBuff, Len(stBuff)
    stBuff = Left$(stBuff, InStr(stBuff, Chr$(0)) - 1)
    WindowTitle = stBuff
End Function

Public Function StripNull(ByVal st As String) As String
    Dim pos As Integer
    StripNull = st
    pos = InStr(1, st, vbNullChar)
    If pos > 0 Then StripNull = Left$(st, pos - 1)
End Function

Public Function LoWord(ByVal LongIn As Long) As Integer
    Call CopyMemory(LoWord, LongIn, 2)
End Function

Public Function HiWord(ByVal LongIn As Long) As Integer
    Call CopyMemory(HiWord, ByVal (VarPtr(LongIn) + 2), 2)
End Function

Public Function MakeLong(ByVal HiWord As Integer, ByVal LoWord As Integer) As Long
    Call CopyMemory(MakeLong, LoWord, 2)
    Call CopyMemory(ByVal (VarPtr(MakeLong) + 2), HiWord, 2)
End Function



